CREATE TABLE Location(
    id INTEGER,
    location_name TEXT,
    city TEXT,
    PRIMARY KEY(id)
);

CREATE TABLE Employment(
    id INTEGER,
    role TEXT,
    dates TEXT,
    duties_1 TEXT,
    duties_2 TEXT,
    duties_3 TEXT,
    location_id INTEGER,
    PRIMARY KEY(id)
    FOREIGN KEY(location_id) REFERENCES Location(id)
);

CREATE TABLE Qualification(
    id INTEGER,
    qual_name TEXT,
    awarding_body TEXT,
    dates TEXT,
    grade TEXT,
    location_id INTEGER,
    PRIMARY KEY(id),
    FOREIGN KEY(location_id) REFERENCES Location(id)
);

CREATE TABLE Framework(
    id INTEGER,
    framework_name TEXT,
    icon TEXT,
    link TEXT,
    PRIMARY KEY(id)
);

CREATE TABLE Project(
    id INTEGER,
    project_name TEXT,
    link TEXT,
    slug TEXT,
    PRIMARY KEY (id)
);

CREATE TABLE Tools(
    project_id INTEGER,
    framework_id INTEGER,

    PRIMARY KEY(project_id, framework_id)

    FOREIGN KEY (project_id) REFERENCES Project(id)
    FOREIGN KEY (framework_id) REFERENCES Framework(id)
);

CREATE TABLE Users(
    id INTEGER,
    email TEXT,
    password TEXT,
    name TEXT,
    PRIMARY KEY (id)
);