from flask import Flask
from flask_sqlalchemy import SQLAlchemy
import os
from dotenv import load_dotenv, dotenv_values
from sqlalchemy.orm import declarative_base
from flask_mail import Mail, Message
from datetime import datetime
from flask_login import LoginManager
from flask_uuid import FlaskUUID
from portfolio.utils import convert_timestamp, from_slug_to_title, render_markdown
from flask_bcrypt import Bcrypt

app = Flask(__name__, static_folder="static")

#filters
app.jinja_env.filters['toDateAndTime'] = convert_timestamp
app.jinja_env.filters['slugToTitle'] = from_slug_to_title
app.jinja_env.filters['markdown'] = render_markdown

#load environment variables
load_dotenv()
app.secret_key = os.getenv("SECRET_KEY")

# mail server:
app.config['MAIL_SERVER'] = 'smtp.gmail.com'
app.config['MAIL_PORT'] = 587
app.config['MAIL_USERNAME'] = os.getenv("MAIL_USERNAME")
app.config['MAIL_PASSWORD'] = os.getenv("MAIL_PASSWORD")
app.config['MAIL_USE_TLS'] = True
app.config['MAIL_USE_SSL'] = False
mail = Mail(app)


# recaptcha
app.config['RECAPTCHA_USE_SSL']= False
app.config['RECAPTCHA_PUBLIC_KEY']= os.getenv("SITE_KEY")
app.config['RECAPTCHA_PRIVATE_KEY']= os.getenv("SECRET_KEY")
app.config['RECAPTCHA_OPTIONS']= {'theme':'black'}

# password security
bcrypt = Bcrypt(app)

# login manager
login_manager = LoginManager()
login_manager.login_view = 'login'
login_manager.init_app(app)



basedir = os.path.abspath(os.path.dirname(__file__))
app.config["SQLALCHEMY_DATABASE_URI"] = "sqlite:///" + os.path.join(basedir, 'portfolio.db')
db = SQLAlchemy(app)

Base = declarative_base()
Base.query = db.session.query_property()

import portfolio.routes