from flask_wtf import FlaskForm, RecaptchaField
from wtforms import StringField, TextAreaField, RadioField, SubmitField, IntegerField, PasswordField
from wtforms.validators import DataRequired, Email, Length, ValidationError
from portfolio.models import *
from portfolio import db

class ContactForm(FlaskForm):
    name = StringField('Name', validators=[DataRequired(), Length(min=2, max=50)])
    email = StringField('Email', validators=[DataRequired(), Email()])
    message = TextAreaField('Message', validators=[DataRequired(), Length(min=10)])
    submit = SubmitField('Send')
    # The recaptcha doesn't work on localhost. Check it in during hosting.
    recaptcha = RecaptchaField()

class Blogpost(FlaskForm):
    author = "Ben"
    slug = StringField('Slug', validators=[DataRequired(), Length(min=10)])
    content = TextAreaField('Content', validators=[DataRequired(), Length(min=10)])
    submit = SubmitField('Send')

class Comment(FlaskForm):
    comment = TextAreaField('Comment', validators=[DataRequired(), Length(min=10)])
    submit = SubmitField('Send')
