from portfolio import app, db, mail, bcrypt, login_manager
from flask import render_template, url_for, redirect, flash, request, session
from portfolio.models import *
from flask_mail import Message, Mail
import os
from dotenv import load_dotenv, dotenv_values
from portfolio.forms import *
import math
from portfolio.utils import *
import uuid
from flask_login import login_user, current_user, login_required, logout_user

load_dotenv()

@app.route("/")
def home():
    if current_user.is_authenticated:
        name = current_user.name
    else:
        name = 'Stranger'
    return render_template('profile.html', name=name)


@app.route('/experience')
def experience():
    employment_list = EmploymentDAO.allEmployment(db)

    return render_template('experience.html', view="work", display=employment_list)


@app.route('/experience/<type>')
def experience_by_type(type):
    if type == 'work':
        experience_list = EmploymentDAO.allEmployment(db)
    if type == 'qualifications':
        experience_list = QualificationDAO.allQualifications(db)
    return render_template('experience.html', view=type, display=experience_list)


@app.route('/contact', methods=['GET', 'POST'])
def contact():
    form = ContactForm()
    if form.validate_on_submit():
        name = form.name.data
        email = form.email.data
        message = form.message.data

        msg = Message(
            subject =f"Contact form from {name}",
            sender = os.getenv("MAIL_USERNAME"),
            recipients =['iornsbj1@cardiff.ac.uk']
        )
        msg.body = f"{name} ({email}) writes: \n {message}"
        mail.send(msg)
        return render_template('thanks.html')

    else:
        print(form.errors)
    return render_template('contact.html', form=form)


@app.route('/projects')
def projects():

    projects_list = ProjectDAO.allProjects(db)
    return render_template('projects.html', projects=projects_list)


@app.route('/thanks')
def thanks():
    return render_template('thanks.html')


@app.route('/blog')
def blog():
    blogposts = BlogpostDAO.allBlogposts(db)

    return render_template('blog.html', blogposts=blogposts )


@app.route('/blog/<slug>', methods=['GET', 'DELETE'])
def blogpost(slug):
    blogpost = BlogpostDAO.blogpostBySlug(db, slug)

    return render_template('blogpost.html', blogpost=blogpost)

@app.route('/blog/new_blogpost', methods=['GET', 'POST'])
@login_required
def newBlogpost():
    form = Blogpost()
    if form.validate_on_submit():
        new_blogpost = BlogpostORM(
            author = "Ben",
            slug = to_slug_case(form.slug.data),
            content = form.content.data,
            timestamp = int(round(datetime.now().timestamp())),
        )
        BlogpostDAO.createBlogpost(db, new_blogpost)

        return render_template('thanks.html')
    else:
        print(form.errors)

    return render_template('newblogpost.html', form=form)


@app.route('/blog/delete_post/<id>')
@login_required
def deleteBlogpost(id):
    BlogpostDAO.deleteBlogpostByID(db, id)

    return render_template('thanks.html')


@app.route('/blog/delete_comment/<id>')
@login_required
def deleteComment(id):
    CommentDAO.deleteCommentByID(db, id)

    return redirect(url_for('blog', next=request.url))


@app.route('/blog/add_comment/<post_id>', methods=['GET', 'POST'])
@login_required
def addComment(post_id):

    form = Comment()
    if form.validate_on_submit():
        new_comment = CommentORM(
            author = current_user.name,
            comment = form.comment.data,
            timestamp = int(round(datetime.now().timestamp())),
            post_id = post_id
        )
        CommentDAO.createComment(db, new_comment)
        return redirect(url_for('blog') + f"#{post_id}")
    else:
        print(form.errors)
    return render_template('newComment.html', form=form)

#@app.route('/login')
#def login():
#    print(request.args.get('next'))
#    return render_template('login.html')

@app.route('/login', methods=['GET', 'POST'])
def login():
    if request.method == 'POST':
        email = request.form.get('email')
        password = request.form.get('password')
        next_url = request.form.get('next')
        user = UserORM.query.filter_by(email=email).first()

        if not user:
            flash('Check your email address.')
            return redirect(url_for('login'))

        if not bcrypt.check_password_hash(user.password, password):
            flash('Passwords don\'t match.')
            return redirect(url_for('login'))

        login_user(user)

        return redirect(next_url)

    if request.method == 'GET':
        return render_template('login.html')


    return redirect(url_for('home'))

@app.route('/signup')
def signup():
    return render_template('signup.html')

@app.route('/signup', methods=['POST'])
def signup_post():
    email = request.form.get('email')
    name = request.form.get('name')
    password = request.form.get('password')
    hashed_password = bcrypt.generate_password_hash(password).decode('utf-8')

    user = UserORM.query.filter_by(email=email).first()

    if user:
        flash('Email address already in use.')
        return redirect(url_for('signup'))

    new_user = UserORM(email=email, name=name, password=hashed_password)

    UserDAO.addNewUser(db, new_user)

    return redirect(url_for('signup'))

@app.route('/logout')
@login_required
def logout():
    logout_user()
    return redirect(url_for('home'))

@login_manager.user_loader
def load_user(id):
    return UserORM.query.get(int(id))